package gov.va.med.mhv.admin.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;
import gov.va.med.mhv.common.data.model.UserProfile;

@Entity
@Table(name = "MVI_AUTH_COMM")
public class MviAuthComm extends AbstractBaseEntity {

	private static final long serialVersionUID = 1L;
	@Id
	@Column(name = "MVI_AUTH_COMM_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "USER_PROFILE_ID", insertable = false, updatable = false)
	private Long userProfileId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_PROFILE_ID")
	private UserProfile userProfile;

	@Column(name = "ACTION")
	private String action;

	@Column(name = "RESULT")
	private String result;

	@Column(name = "DETAIL")
	private String detail;

	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdTime;

	@Column(name = "CRON_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date cronTime;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	public Date getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	public Date getCronTime() {
		return cronTime;
	}

	public void setCronTime(Date cronTime) {
		this.cronTime = cronTime;
	}
}
